//
//  QRCodeAccessNotificationViewController.swift
//  HCSStudies
//
//  Created by Marvin Kowalewski on 28.06.23.
//

import Foundation
import UIKit

class QRCodeAccessNotificationViewController: UIViewController {
    
    
    @IBOutlet var step1Label: UILabel!
    
    @IBOutlet var step2Label: UILabel!
    
    @IBOutlet var step3Label: UILabel!
    
    @IBOutlet var step4Label: UILabel!
    
    @IBOutlet var step5Label: UILabel!
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        step1Label.textColor = Colors.greyColor
        step1Label.font = Fonts.mediumFontWithSize(size: 16)
        
        step2Label.textColor = Colors.greyColor
        step2Label.font = Fonts.mediumFontWithSize(size: 16)
        
        
        step3Label.font = Fonts.mediumFontWithSize(size: 16)
        step3Label.textColor = Colors.greyColor
        
        let step3Details = NSMutableAttributedString.init(string: "1. Gehen Sie dazu in Ihre Smartphone Einstellungen.")
        
        step3Details.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 16),
                                    NSAttributedString.Key.foregroundColor: Colors.carmine],
                                   range: NSMakeRange(0, 2))
        
        step3Label.attributedText = step3Details
        
        
        step4Label.textColor = Colors.greyColor
        step4Label.font = Fonts.mediumFontWithSize(size: 16)
        
        let step4Details = NSMutableAttributedString.init(string: "2. Scrollen Sie runter bis zur HCS Studies App und klicken Sie auf „HCS Studies“.")
        
        step4Details.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 16),
                                    NSAttributedString.Key.foregroundColor: Colors.carmine],
                                   range: NSMakeRange(0, 2))
        
        step4Label.attributedText = step4Details
        
        
        step5Label.textColor = Colors.greyColor
        step5Label.font = Fonts.mediumFontWithSize(size: 16)
        
        let step5Details = NSMutableAttributedString.init(string: "3. Erlauben Sie dort den Zugriff auf die Kamera.")
        
        step5Details.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 16),
                                    NSAttributedString.Key.foregroundColor: Colors.carmine],
                                   range: NSMakeRange(0, 2))
        
        step5Label.attributedText = step5Details
    }
    
    @IBAction func doneButton(_ sender: Any) {
        let tabBarController = self.storyboard?.instantiateViewController(withIdentifier: "OnlineBankingTBC") as! UITabBarController
        
        tabBarController.modalPresentationStyle = .fullScreen
        tabBarController.modalTransitionStyle = .crossDissolve
        self.present(tabBarController, animated: true)
        
        // https://www.youtube.com/watch?v=43LpNQtUvV4
        let indexData: [String: Int] = ["index" : 1]
        NotificationCenter.default.post(name: Notification.Name("changeIndex"), object: nil, userInfo: indexData)
    }
    
}

